<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Classes extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('class_master_model');
        $this->load->model('announcements_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('classes', '', 'view')) {
            access_denied('classes');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('master_class');
        }
       
        $sheader_text = title_text('aside_menu_active', 'classes');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        $data['name_'] = $sheader_text;
        
        $data['title']     = _l($sheader_text);
        $this->load->view('admin/classes/classes', $data);
    }
    
    /**
    *   @Function: details
    */
    public function details($cid)
    {
        $sheader_text = title_text('aside_menu_active', 'classes');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        $title = str_replace('_',' ',$cid);
        $data['title']     = _l($title);
        $_SESSION['classid'] = $title;
        $data['cid'] = $this->db->get_where(db_prefix().'master_class', array('name' => $title))->row('class_id');
        
        $data['campus_graph_by_student'] = json_encode($this->class_master_model->campus_graph_by_student($title));
        $data['gender_graph_by_student'] = json_encode($this->class_master_model->gender_graph_by_student($title));
        $tab = $_GET['tab'];
        if($tab)
        {
            if($tab == 'Birthday')
            {
                $data['birthday_result'] = $this->db->select('firstname,lastname,id,Date_of_Birth,userid')->order_by('Date_of_Birth','desc')->get_where(db_prefix().'contacts', array('Class' => $title))->result();
            }
            elseif($tab == 'Overview')
            {
                $data['campus_graph_by_student'] = json_encode($this->class_master_model->campus_graph_by_student($title));
                $data['gender_graph_by_student'] = json_encode($this->class_master_model->gender_graph_by_student($title));
            }
            elseif($tab == 'student_list')
            {
                if ($this->input->is_ajax_request()) {
                    $this->app->get_table_data('student_list');
                }
            }
            elseif($tab == 'last_login')
            {
                if ($this->input->is_ajax_request()) {
                    $this->app->get_table_data('last_login');
                }
            }
            elseif($tab == 'inactive')
            {
                if ($this->input->is_ajax_request()) {
                    $this->app->get_table_data('inactive');
                }
            }
            elseif($tab == 'class_announcements')
            {
                if ($this->input->is_ajax_request()) {
                    $this->app->get_table_data('class_announcements');
                }
                if ($this->input->post()) {
                    $data            = $this->input->post();
                    $data['message'] = $this->input->post('message', false);
                    if ($id == '') {
                        $id = $this->announcements_model->add($data);
                        if ($id) {
                            set_alert('success', _l('added_successfully', _l('announcement')));
                            redirect($_SERVER['HTTP_REFERER']);
                            //redirect(admin_url('announcements/view/' . $id));
                        }
                    } else {
                        $success = $this->announcements_model->update($data, $id);
                        if ($success) {
                            set_alert('success', _l('updated_successfully', _l('announcement')));
                        }
                        //redirect(admin_url('announcements/view/' . $id));
                        redirect($_SERVER['HTTP_REFERER']);
                    }
                }
            }
            $data['page'] = $tab;
            $data['tab'] = $tab;
        }
        else
        {
            $data['campus_graph_by_student'] = json_encode($this->class_master_model->campus_graph_by_student($title));
            $data['gender_graph_by_student'] = json_encode($this->class_master_model->gender_graph_by_student($title));
            $data['page'] = 'Overview';
            $data['tab'] = 'Overview';
        }
        
        $this->load->view('admin/classes/classdetails', $data);
    }
}
