<?php

defined('BASEPATH') or exit('No direct script access allowed');

class ClassMaster extends AdminController
{
    /* List all class master */
    public function index()
    {
        $this->load->model('class_master_model');
        if (!has_permission('class_', '', 'view')) {
            access_denied('class_');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('master_class');
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'class_');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['title'] = _l($subheader_text);
        $this->load->view('admin/classMaster/manage', $data);
    }

    /* Add new role or edit existing one */
    public function role($id = '')
    {
        $this->load->model('class_master_model');
        if (!has_permission('class_', '', 'view')) {
            access_denied('class_');
        }
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('class_', '', 'create')) {
                    access_denied('class_');
                }
                $id = $this->class_master_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('class')));
                    redirect(admin_url('classMaster/role/' . $id));
                }
            } else {
                if (!has_permission('class_', '', 'edit')) {
                    access_denied('class_');
                }
                $success = $this->class_master_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('class')));
                }
                redirect(admin_url('classMaster/role/' . $id));
            }
        }
        
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'class_');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        if ($id == '') {
            $title = _l('add_new', _l('class'));
        } else {
            $role               = $this->class_master_model->get($id);
            $data['role']       = $role;
            $title              = _l('edit', _l('class')) . ' ' . $role->name;
        }
        
        $data['title'] = $subheader_text;
        $this->load->view('admin/classMaster/role', $data);
    }

    /* Delete role from database */
    public function delete($id)
    {
        $this->load->model('class_master_model');
        if (!has_permission('class_', '', 'delete')) {
            access_denied('class_');
        }
        if (!$id) {
            redirect(admin_url('classMaster'));
        }
        $response = $this->class_master_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('class master')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('class')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('class master')));
        }
        redirect(admin_url('classMaster'));
    }
}
