<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Checklist extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('checklist_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('checklist', '', 'view')) {
            access_denied('checklist');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('checklist');
        }
       
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'checklist');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;
        
        $data['title']     = _l($subheader_text);
        $this->load->view('admin/checklist/checklists', $data);
    }

    /* Add new article or edit existing*/
    public function add($id = '')
    {
        if (!has_permission('checklist', '', 'view')) {
            access_denied('checklist');
        }
        if ($this->input->post()) {
            $data                = $this->input->post();
            
            if ($id == '') {
                if (!has_permission('checklist', '', 'create')) {
                    access_denied('checklist');
                }
                
                $existname = $this->db->get_where(db_prefix().'master_checklist', array('title' => $data['title']))->row('title');
                if($existname)
                {
                    set_alert('warning', _l($data['title'].' title is existing'));
                    redirect(admin_url('checklist'));
                }
                else
                {
                    $data['created_at'] = date('Y-m-d h:i:s');
                    $id = $this->checklist_model->add_article($data);
                    if ($id) {
                        set_alert('success', _l('added_successfully', _l('Checklist')));
                        redirect(admin_url('checklist'));
                    }
                }
            } else {
                if (!has_permission('checklist', '', 'edit')) {
                    access_denied('checklist');
                }
                $success = $this->checklist_model->update_article($data, $id);
                
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('Checklist')));
                }
                redirect(admin_url('checklist'));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('Checklist'));
        } else {
            $article         = $this->checklist_model->get($id);
           // echo '<pre>'; print_r($article); die;
            $data['article'] = $article;
            $title           = _l('edit', _l('Checklist')) . ' ' . $article->name;
        }
        $subheader_text = setupTitle_text('setup_menu_active', 'master', 'checklist');
        $data['sheading_text'] = $subheader_text;
        $data['sh_text'] = $subheader_text;

        $data['title']     = _l($subheader_text);
        $this->load->view('admin/checklist/checklist', $data);
    }

    /* Delete article from database */
    public function delete_checklist($id)
    {
        if (!has_permission('checklist', '', 'delete')) {
            access_denied('checklist');
        }
        if (!$id) {
            redirect(admin_url('checklist'));
        }
        $response = $this->checklist_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('Checklist')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('Checklist')));
        }
        redirect(admin_url('checklist'));
    }
}
