<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Certificates extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }

    /* List all knowledgebase articles */
    public function index()
    {
        /*
        if (!has_permission('certificates', '', 'view')) {
            access_denied('certificates');
        }
        */
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('certificates');
        }
       
        $sheader_text = title_text('aside_menu_active', 'certificates');
        $data['sheading_text'] = $sheader_text;
        $data['sh_text'] = $sheader_text;
        
        $data['title']     = _l($sheader_text);
        $data['class_list'] = $this->db->get_where(db_prefix().'master_class')->result();
        $this->load->view('admin/certificates/certificates', $data);
    }
    
    /**
    *   Function: classList
    */
    public function studentList($classname)
    {
        if($classname)
        {
            $classname_ = str_replace('_',' ',$classname);
            $data['classname'] = $classname_;
            $_SESSION['_classname'] = $classname_;
            
            if ($this->input->is_ajax_request()) {
                $this->app->get_table_data('certificates_studentlist');
            }
            
            if($classname_ == 'Playgroup')
            {
                $total_student = $this->db->get_where(db_prefix().'contacts', array('Class' => $classname_))->num_rows();
                $total_student_ = $this->db->get_where(db_prefix().'contacts', array('Class' => 'PG'))->num_rows();
                $data['total_student'] = $total_student + $total_student_;
                
                $total_activestudent = $this->db->select('userid')->get_where(db_prefix().'contacts', array('Class' => $classname_))->result();
                $studentid = [];
                if($total_activestudent)
                {
                    foreach($total_activestudent as $r)
                    {
                        array_push($studentid, $r->userid);
                    }
                }
                
    			$this->db->select('id');
    			$this->db->from(db_prefix().'student_result');
    			$this->db->where_in('student_id',$studentid);
    			$completeres = $this->db->get()->num_rows();
    			$data['pending_result'] = $data['total_student'] - $completeres;
                $data['completed_result'] = $completeres;
            }
            else
            {
                $total_activestudent = $this->db->select('userid')->get_where(db_prefix().'contacts', array('Class' => $classname_))->result();
                $studentid = [];
                if($total_activestudent)
                {
                    foreach($total_activestudent as $r)
                    {
                        array_push($studentid, $r->userid);
                    }
                }
                
    			$this->db->select('id');
    			$this->db->from(db_prefix().'student_result');
    			$this->db->where_in('student_id',$studentid);
    			$completeres = $this->db->get()->num_rows();
    			
                $data['total_student'] = $this->db->get_where(db_prefix().'contacts', array('Class' => $classname_))->num_rows();
                $data['pending_result'] = $data['total_student'] - $completeres;
                $data['completed_result'] = $completeres;
            }
            
            $data['class_list'] = $this->db->get_where(db_prefix().'master_class')->result();
            $header_text = title_text('aside_menu_active', 'certificates');
            $data['heading_text'] = $header_text;
            $data['title']          = _l($header_text);
            $this->load->view('admin/certificates/certificates_studentlist', $data);
        }
        else
        {
            set_alert('error', _l('Class not found'));
            redirect(admin_url('certificates'));
        }
    }
    
    /**
    *   Function: getSubjectList
    **/
    public function getSubjectList()
    {
        $classid = $_POST['cid'];
        $uid = $_POST['uid'];
        $rid = $_POST['rid'];
        $html = '';
        if($rid > 0)
        {
            //$data['exresult'] = $this->db->get_where(db_prefix().'suject_result', array('result_id' => $rid))->result();
            $data['editTerm_result'] = $this->db->get_where(db_prefix().'student_certificates', array('id' => $rid))->row();
            $activityname = $data['editTerm_result']->activity_name;
            $prefix = $data['editTerm_result']->prefix_name;
            $prefix_event = $data['editTerm_result']->prefix_event;
        }
        else
        {
            //$data['exresult'] = ''; 
            $data['editTerm_result'] = '';
            $activityname = '';
            $prefix = '';
            $prefix_event = '';
        }
    
        if($classid)
        {
            $data['uid'] = $uid;
            $data['rid'] = $rid;
            $data['classid'] = $classid;
            $data['prefix'] = $prefix;
            $data['prefix_event'] = $prefix_event;
            $data['activityname'] = $activityname;
            $studentname = $this->db->select('firstname,lastname')->get_where(db_prefix().'contacts', array('userid' => $uid))->row();
            $data['studentname'] = $studentname->firstname.' '.$studentname->lastname;
            //$data['grad_list'] = $this->db->get_where(db_prefix().'result_grade')->result();
            //$data['subjectlist'] = $this->db->order_by('subject_id', 'desc')->get_where(db_prefix().'master_subject', array('class_id' => $classid))->result(); 
            $data['participatingList'] = $this->db->order_by('name', 'asc')->get_where(db_prefix().'certificates_participating', array('status' => 1))->result(); 
            $html = $this->load->view('admin/certificates/subjectlist', $data, true);
        }
        echo $html;
    }
    
    /**
    *   @Function: studentres
    */
    public function add()
    {
        $data = $this->input->post();
        $rid  = $data['rid'];
        $resultdata['class_id'] = $data['class_id'];
        $resultdata['prefix_event'] = $data['prefix_event'];
        $resultdata['prefix_name'] = $data['prefix_name'];
        $resultdata['student_id'] = $data['student_id'];
        $resultdata['activity_name'] = $data['activity_name'];
        
        $exid = $this->db->get_where(db_prefix().'student_certificates', array('id' => $rid))->result();
        if($exid)
        {
            $update['prefix_name'] = $resultdata['prefix_name'];
            $update['prefix_event'] = $resultdata['prefix_event'];
            $update['activity_name'] = $resultdata['activity_name'];
            $this->db->where('id', $rid);
            $this->db->update(db_prefix().'student_certificates', $update);
            set_alert('success', _l('Certificate update successfully'));
        }
        else
        {
            $resultdata['created_date'] = date('Y-m-d h:i:s');
            $this->db->insert(db_prefix().'student_certificates', $resultdata);
            set_alert('success', _l('Certificate created successfully'));
        }
        
        $_classname = str_replace(' ','_',$_SESSION['_classname']);
        redirect(admin_url('certificates/studentList/'.$_classname));
    }
    
    /**
    *   @Function: studentres
    */
    public function studentres()
    {
        $data = $this->input->post();
        $rid  = $data['rid'];
        $resultdata['class_id'] = $data['class_id'];
        $resultdata['student_id'] = $data['student_id'];
        $resultdata['exam_id'] = $data['exam_id'];
        
        if($rid > 0)
        {
            $this->db->delete(db_prefix().'suject_result', array('result_id' => $rid));
            $subjectarr = $data['subject_id'];
            $gradarr   = $data['grad_id'];
            $subcount = count($data['subject_id']);
            for($i = 0; $i < $subcount; $i++)
            {
                $postdata['student_id']  = $data['student_id']; 
                $postdata['result_id']   = $rid; 
                $postdata['subject_id']  = $subjectarr[$i]; 
                $postdata['grad_id']     = $gradarr[$i]; 
                
                $this->db->insert(db_prefix().'suject_result', $postdata);
            }
            set_alert('success', _l('Certificate updated successfully'));
        }
        else
        {
            $this->db->insert(db_prefix().'student_result', $resultdata);
            $resultid = $this->db->insert_id();
            if($resultid)
            {
                $subjectarr = $data['subject_id'];
                $gradarr   = $data['grad_id'];
                $subcount = count($data['subject_id']);
                for($i = 0; $i < $subcount; $i++)
                {
                    $postdata['student_id']  = $data['student_id']; 
                    $postdata['result_id']   = $resultid; 
                    //$postdata['subject_id']  = $subjectarr[$i]; 
                    $postdata['grad_id']     = $gradarr[$i]; 
                    
                    $this->db->insert(db_prefix().'suject_result', $postdata);
                }
                set_alert('success', _l('Certificate created successfully'));
            }
        }
            
        $_classname = str_replace(' ','_',$_SESSION['_classname']);
        redirect(admin_url('certificates/studentList/'.$_classname));
    }
}
